
	$(document).ready(function() {
		
		if($(".item_tabs").length > 0){tabFunction()};
		
		$(".tab_title").click(function(){
			if(!$(this).hasClass('active')){
				$(this).siblings().removeClass('active').end().addClass('active');
				tabFunction();
			}
			return false;
		});
		
		if($(".item_block").length > 0){
			previewImage();
		}
		
		if($('.fancybox').length > 0){
			$("a.fancybox").fancybox({
				padding: 30
			});
		}
		
		$(".item_thumbs > ul > li > a").live('click', function(){
			if(!$(this).closest('li').hasClass('active')){
				$(this).closest('li').siblings().removeClass('active').end().addClass('active');
				loadImage();
			}
			return false;
		});
	
	});
	
	function tabFunction(){
		$(".item_tabs").each(function(){
			var tabs = $(this);
			if(tabs.find('.tab_title.active').length == 0){tabs.find('.tab_title:first').addClass('active')};
			var activeTab = tabs.find('.tab_title.active').attr('tab-title');			
			tabs.find('.tab.active').removeClass('active');
			tabs.find('.tab[tab-content='+activeTab+']').addClass('active');
		});
	};
	
	function previewImage(){
		$(".item_thumbs li").each(function(ind){
			var thumbLink = $(this).find("a");
			thumbLink.attr('data-thumb', 'thumb-'+ind);
			if($(".item_image .item_image_links").length == 0){
				$(".item_image").append('<div class="item_image_links"></div>');
			}
			$(".item_image_links").append('<a href='+thumbLink.attr('href')+' data-link="thumb-'+ind+'" class="fancybox" rel="item-preview"></a>');
		});
		loadImage();
		
		$(".zoomLink").live('click', function(){
			var activeThumbnail = $(".item_thumbs li.active a").attr('data-thumb');
			$(".item_image_links a[data-link="+activeThumbnail+"]").click();
			return false;
		});
	}
	
	function loadImage(){
		if($(".item_thumbs li.active").length == 0){$(".item_thumbs li:first").addClass('active');}
		var activeThumb = $(".item_thumbs li.active");
		var activeThumbLink = activeThumb.find('a');
		$(".zoomLink").attr('data-zoomsrc', activeThumbLink.attr('href'));
		$("#largeImg").fadeOut(100, function(){
			$(this).attr('src', activeThumbLink.attr('href')).load(function(){$("#largeImg").fadeIn(100)});
		});
	}
	
	// function zoomInit(){
		// var zoomSrc = $(".zoomLink").attr("data-zoomsrc");
		// MojoZoom.makeZoomable(
			// document.getElementById("largeImg"),   
			// zoomSrc,  
			// document.getElementById("zoomImg_zoom"),
			// false  
		// ); 
	// }
	
